package gov.va.vinci.dart.db.mock;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

import gov.va.vinci.dart.common.exception.ObjectNotFoundException;
import gov.va.vinci.dart.biz.Location;
import gov.va.vinci.dart.db.LocationDAO;

public class LocationDAOMock implements LocationDAO {

	private static final HashMap<Integer,Location> IDHash = new HashMap<Integer,Location>();
	private static final HashMap<String,Location> NameHash = new HashMap<String,Location>();
	private static boolean initialized = false;
	
	@Override
	public Location findById(int locationId) throws ObjectNotFoundException  {

		initializeLocationHashes();
		
		Location result = IDHash.get(locationId);
		
		if (result == null) {
			throw new ObjectNotFoundException();
		}
		
		return result;
	}

	@Override
	public Location findByName(String name) throws ObjectNotFoundException {
		initializeLocationHashes();

		Location result = NameHash.get(name);
		
		if (result == null) {
			throw new ObjectNotFoundException();
		}
		
		return result;
	}

	@Override
	public List<Location> listAll() {
		List<Location> result = new ArrayList<Location>();

		initializeLocationHashes();

		for (Integer id: IDHash.keySet()) {
			result.add(IDHash.get(id));
		}
		
		return result;
	}

	private void createLocation(final int id, final String name) {
		Location loc = new Location();
		loc.setId(id);
		loc.setName(name);
		loc.setDescription(name);
		IDHash.put(loc.getId(),loc);
		NameHash.put(loc.getName(),loc);
	}
	
	private void initializeLocationHashes() {
		if (initialized == true) {
			return;
		}
		
		initialized = true;
		
		createLocation(1, "(358) Manila, Philippines");
		createLocation(2, "(402) Togus ME");
		createLocation(3, "(405) White River Junction VT");
		createLocation(4, "(436) Montana HCS (Fort Harrison MT)");
		createLocation(5, "(437) Fargo, ND (CACHE 5.0)");
		createLocation(6, "(438) Sioux Falls SD (CACHE 5.0)");
		createLocation(7, "(442) Cheyenne WY");
		createLocation(8, "(459) VA Pacific Islands HCS (Honolulu HI)");
		createLocation(9, "(460) Wilmington DE");
		createLocation(10, "(463) Alaska VAHSRO (Anchorage AK)");
		createLocation(11, "(501) New Mexico HCS (Albuquerque NM)");
		createLocation(12, "(502) Alexandria, LA");
		createLocation(13, "(503) Altoona, PA");
		createLocation(14, "(504) Amarillo HCS (Amarillo TX)");
		createLocation(15, "(506) Ann Arbor, MI");
		createLocation(16, "(508) Atlanta, GA");
		createLocation(17, "(509) Augusta, GA");
		createLocation(18, "(512) Maryland HCS (Baltimore MD)");
		createLocation(19, "(515) Battle Creek, MI");
		createLocation(20, "(516) Bay Pines,FL");
		createLocation(21, "(517) Beckley, WV");
		createLocation(22, "(518) Bedford,MA");
		createLocation(23, "(519) West Texas HCS (Big Spring TX)");
		createLocation(24, "(520) Biloxi, MS");
		createLocation(25, "(521) Birmingham, AL");
		createLocation(26, "(523) Boston HCS (Boston)");
		createLocation(27, "(526) Bronx, NY");
		createLocation(28, "(528) Upstate New York HCS");
		createLocation(29, "(529) Butler, PA");
		createLocation(30, "(531) Boise,ID");
		createLocation(31, "(534) Charleston, SC");
		createLocation(32, "(537) Chicago (Westside), IL");
		createLocation(33, "(538) Chillicothe, OH");
		createLocation(34, "(539) Cincinnati, OH");
		createLocation(35, "(540) Clarksburg, WV");
		createLocation(36, "(541) Cleveland, OH");
		createLocation(37, "(542) Coatesville, PA");
		createLocation(38, "(544) Columbia, SC");
		createLocation(39, "(546) Miami, FL");
		createLocation(40, "(548) West Palm Beach, FL");
		createLocation(41, "(549) North Texas HCS (Dallas TX)");
		createLocation(42, "(550) Illiana HCS (Danville IL)");
		createLocation(43, "(552) Dayton, OH");
		createLocation(44, "(553) Detroit, MI");
		createLocation(45, "(554) Eastern Colorado HCS (Denver CO)");
		createLocation(46, "(556) North Chicago, IL");
		createLocation(47, "(557) Dublin, GA");
		createLocation(48, "(558) Durham, NC");
		createLocation(49, "(561) New Jersey HCS (East Orange)");
		createLocation(50, "(562) Erie, PA");
		createLocation(51, "(564) Fayetteville, AR");
		createLocation(52, "(565) Fayetteville, NC");
		createLocation(53, "(568) Black Hills HCS (Fort Meade SD) (CACHE 5.0)");
		createLocation(54, "(570) Central California HCS (Fresno CA)");
		createLocation(55, "(573) N. Florida/S. Georgia HCS (Gainesville FL)");
		createLocation(56, "(575) Grand Junction, CO");
		createLocation(57, "(578) Hines, IL");
		createLocation(58, "(580) Houston, TX");
		createLocation(59, "(581) Huntington, WV");
		createLocation(60, "(583) Indianapolis, IN");
		createLocation(61, "(585) Iron Mountain, MI");
		createLocation(62, "(586)  Jason , MS");
		createLocation(63, "(589) VA Heartland West (Kansas City MO)");
		createLocation(64, "(590) Hampton, VA");
		createLocation(65, "(593) Southern Nevada HCS (Las Vegas NV)");
		createLocation(66, "(595) Lebanon, PA");
		createLocation(67, "(596) Lexington, KY");
		createLocation(68, "(598) Central Arkansas HCS (Little Rock AR)");
		createLocation(69, "(600) Long Beach HCS (Long Beach CA)");
		createLocation(70, "(603) Louisville, KY");
		createLocation(71, "(605) Loma Linda, CA");
		createLocation(72, "(607) Madison, WI");
		createLocation(73, "(608) Manchester, NH");
		createLocation(74, "(610) Northern Indiana HCS (Marion, IN)");
		createLocation(75, "(612) Northern California HCS (Martinez CA)");
		createLocation(76, "(613) Martinsburg, WV");
		createLocation(77, "(614) Memphis, TN");
		createLocation(78, "(618) Minneapolis, MN (CACHE 5.0)");
		createLocation(79, "(619) Central Alabama HCS (Montgomery AL)");
		createLocation(80, "(620) Hudson Valley HCS (Castle Point, Montrose)");
		createLocation(81, "(621) Mountain Home, TN");
		createLocation(82, "(623) Muskogee, OK");
		createLocation(83, "(626) Tennessee Valley HCS (Nashville TN)");
		createLocation(84, "(629) New Orleans, LA");
		createLocation(85, "(630) New York HHS (Brooklyn)");
		createLocation(86, "(631) Northampton, MA");
		createLocation(87, "(632) Northport, NY");
		createLocation(88, "(635) Oklahoma City, OK");
		createLocation(89, "(636) Central Plains HCS (Omaha NE)");
		createLocation(90, "(637) Asheville, NC");
		createLocation(91, "(640) Palo Alto HCS (Palo Alto CA)");
		createLocation(92, "(642) Philadelphia, PA");
		createLocation(93, "(644) Phoenix, AZ");
		createLocation(94, "(646) Pittsburgh HCS (Pittsburgh PA)");
		createLocation(95, "(648) Portland, OR (CACHE 5.0)");
		createLocation(96, "(649) Northern Arizona HCS (Prescott AZ)");
		createLocation(97, "(650) Providence, RI");
		createLocation(98, "(652) Richmond, VA");
		createLocation(99, "(653) Roseburg HCS (Roseburg OR)");
		createLocation(100, "(654) Sierra Nevada HCS (Reno NV)");
		createLocation(101, "(655) Saginaw, MI");
		createLocation(102, "(656) St. Cloud, MN (CACHE 5.0)");
		createLocation(103, "(657) VA Heartland East (Saint Louis MO)");
		createLocation(104, "(658) Salem, VA");
		createLocation(105, "(659) Salisbury, NC");
		createLocation(106, "(660) Salt Lake City HCS (Salt Lake City UT)");
		createLocation(107, "(662) San Francisco, CA");
		createLocation(108, "(663) Puget Sound HCS (Seattle WA) (CACHE 5.0)");
		createLocation(109, "(664) San Diego HCS (San Diego CA)");
		createLocation(110, "(666) Sheridan, WY");
		createLocation(111, "(667) Shreveport, LA");
		createLocation(112, "(668) Spokane, WA");
		createLocation(113, "(671) South Texas HCS (San Antonio TX)");
		createLocation(114, "(672) San Juan, PR");
		createLocation(115, "(673) Tampa, FL");
		createLocation(116, "(674) Central Texas HCS (Temple TX)");
		createLocation(117, "(675) Orlando, FL");
		createLocation(118, "(676) Tomah, WI");
		createLocation(119, "(678) Southern Arizona HCS (Tucson AZ)");
		createLocation(120, "(679) Tuscaloosa, AL");
		createLocation(121, "(687) Walla Walla, WA");
		createLocation(122, "(688) Washington DC");
		createLocation(123, "(689) Connecticut HCS (Westhaven)");
		createLocation(124, "(691) Greater Los Angeles HCS (Los Angeles CA)");
		createLocation(125, "(692) White City, OR (CACHE 5.0)");
		createLocation(126, "(693) Wilkes-Barre, PA");
		createLocation(127, "(695) Milwaukee, WI");
		createLocation(128, "(740) Texas Valley Coastal Bend HCS (Harlingen TX)");
		createLocation(129, "(756) El Paso, TX");
		createLocation(130, "(757) Columbus, OH");
		createLocation(1001, "(101) Central Office");
		createLocation(1002, "(200) AITC");
		createLocation(1003, "(301) Boston");
		createLocation(1004, "(304) Providence");
		createLocation(1005, "(306) New York");
		createLocation(1006, "(307) Buffalo");
		createLocation(1007, "(308) Hartford");
		createLocation(1008, "(309) Newark");
		createLocation(1009, "(310) Philadelphia");
		createLocation(1010, "(311) Pittsburgh");
		createLocation(1011, "(313) Baltimore");
		createLocation(1012, "(314) Roanoke");
		createLocation(1013, "(315) Huntington");
		createLocation(1014, "(316) Atlanta");
		createLocation(1015, "(317) St. Petersburg");
		createLocation(1016, "(318) Winston-Salem");
		createLocation(1017, "(319) Columbia");
		createLocation(1018, "(320) Nashville");
		createLocation(1019, "(321) New Orleans");
		createLocation(1020, "(322) Montgomery");
		createLocation(1021, "(323)  Jason ");
		createLocation(1022, "(325) Cleveland");
		createLocation(1023, "(326) Indianapolis");
		createLocation(1024, "(327) Louisville");
		createLocation(1025, "(328) Chicago");
		createLocation(1026, "(329) Detroit");
		createLocation(1027, "(330) Milwaukee");
		createLocation(1028, "(331) St. Louis");
		createLocation(1029, "(333) Des Moines");
		createLocation(1030, "(334) Lincoln");
		createLocation(1031, "(339) Denver");
		createLocation(1032, "(340) Albuquerque");
		createLocation(1033, "(341) Salt Lake City");
		createLocation(1034, "(343) San Francisco/Oakland");
		createLocation(1035, "(344) Los Angeles");
		createLocation(1036, "(345) Phoenix");
		createLocation(1037, "(346) Seattle");
		createLocation(1038, "(347) Boise");
		createLocation(1039, "(348) Portland");
		createLocation(1040, "(349) Waco");
		createLocation(1041, "(350) Little Rock");
		createLocation(1042, "(351) Muskogee");
		createLocation(1043, "(354) Reno");
		createLocation(1044, "(355) San Juan");
		createLocation(1045, "(359) Honolulu");
		createLocation(1046, "(362) Houston");
		createLocation(1047, "(372) Washington");
		createLocation(1048, "(373) Manchester");
		createLocation(1049, "(376) St. Louis");
		createLocation(1050, "(377) San Diego");
		createLocation(1051, "(452) Wichita");
		createLocation(1052, "(500) Albany");
		createLocation(1053, "(525) Brockton");
		createLocation(1054, "(527) Brooklyn");
		createLocation(1055, "(532) Canandaigua");
		createLocation(1056, "(533) Castle Point");
		createLocation(1057, "(535) Chicago (Lakeside) ");
		createLocation(1058, "(543) Columbia");
		createLocation(1059, "(555) Des Moines");
		createLocation(1060, "(567) Fort Lyon");
		createLocation(1061, "(574) Grand Island");
		createLocation(1062, "(584) Iowa City");
		createLocation(1063, "(591) Kerrville");
		createLocation(1064, "(592) Knoxville");
		createLocation(1065, "(594) Lake City");
		createLocation(1066, "(597) Lincoln");
		createLocation(1067, "(609) Marion");
		createLocation(1068, "(617) Miles City");
		createLocation(1069, "(622) Murfreesboro");
		createLocation(1070, "(627) Newington");
		createLocation(1071, "(645) Pittsburgh (Highland Drive) ");
		createLocation(1072, "(647) Polar Bluff");
		createLocation(1073, "(670) Syracuse");
		createLocation(1074, "(677) Topeka");
		createLocation(1075, "(680) Tuskegee");
		createLocation(1076, "(685) Waco");
		createLocation(1077, "(696) Honolulu");
		createLocation(1078, "(512A4) Fort Howard");
		createLocation(1079, "(512A5) Perry Point");
		createLocation(1080, "(528A4) Batavia");
		createLocation(1081, "(610A4) VA NIHCC (Ft Wayne and Marion Divisions) ");
		createLocation(1082, "(674A4) Waco");
		createLocation(1083, "(674A5) Marlin");

	}
}
